#MEMBUKA FILE DATA
dataDirectory <- "D:/SVM/Golongan AB/"
data <- read.csv(paste(dataDirectory,'Golongan AB Train.txt', sep=""),header = TRUE)

#PETA PLOT DATA

plot(data, pch=16)

#Install Package
install.packages("e1071")

#Load Library
library(e1071)

#Create svm model
model <- svm( y ~ x , data)

#Make a prediction for each x
predictedY <- predict(model, data)

points(data$x, predictedY, col = "red",pch=4)

#perform a grid search
tuneResult <- tune(svm, y ~ x, data = data,kernel="radial",ranges = list(epsilon = seq(0,1,0.1), cost = 2^(-5:10), gamma = 2^(-6:3)))

print(tuneResult)

summary(tuneResult)

getOption("max.print")

options(max.print = 99999999)

out <- capture.output(summary(tuneResult))
cat("My title", out, file="summary_of_tune_Result_Data_Training_Gol_AB.txt", sep="n", append=TRUE)

tunedModel <- tuneResult$best.model

tunedModelY <- predict(tunedModel, data)

points(data$x,tunedModelY,col = "green",pch=4)

print(tunedModelY)

